package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class GoalScreenObject extends ScreenObject {

private IntRect clickRect;
	
	private boolean isSelected;
	
	public static final int GOAL_WIDTH = 67;
	public static final int GOAL_HEIGHT = 55;
	private CustomImageDataII image;
	
//	private CustomImageDataII [] cutsceneImages;
	private GoalScreenPaletteObject paletteObject;
	private boolean passThru;
	private boolean enableCommentary;
	
	public GoalScreenObject(int x, int y, ImageObserver io, GoalScreenPaletteObject thePaletteObject, boolean thePassThruFlag, boolean theEnableCommentary) { //CustomImageDataII [] theCutsceneImages
		
		int clickRectMinX = x - GOAL_WIDTH / 2;
		int clickRectMinY = y - GOAL_HEIGHT / 2;
		
		clickRect = new IntRect(clickRectMinX, clickRectMinY, GOAL_WIDTH,GOAL_HEIGHT);
		
		image = new CustomImageDataII("/images/goal.GIF", Color.green, io);
		
		
//		cutsceneImages = theCutsceneImages;
		paletteObject = thePaletteObject;
		passThru = thePassThruFlag;
		enableCommentary = theEnableCommentary;
		
	}
	
	
	@Override
	public void draw(Graphics g) {
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		if(isSelected)
			drawSelectionOverObject(g);
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	public boolean isSelected() {
		return isSelected;
	}

	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}


	@Override
	public void setClickRect(IntRect newRect) {
		// TODO Auto-generated method stub
		
	}

	
	
	public boolean passThru() {
		return passThru;
	}
	
	public boolean enableCommentary() {
		return enableCommentary;
	}


//	public CustomImageDataII[] getCutsceneImages() {
//		return cutsceneImages;
//	}
//
//
//	public void setCutsceneImages(CustomImageDataII[] cutsceneImages) {
//		this.cutsceneImages = cutsceneImages;
//	}
	
	public GoalScreenPaletteObject getPaletteObject() {
		return paletteObject;
	}
	
	public void setPaletteObject(GoalScreenPaletteObject thePaletteObject) {
		paletteObject = thePaletteObject;
	}


	public void setPassThru(boolean passThru) {
		this.passThru = passThru;
	}


	public void setEnableCommentary(boolean enableCommentary) {
		this.enableCommentary = enableCommentary;
	}
	
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("goal:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();

		if(passThru) {
			out.write("passThru");
		} else {
			out.write("solid");
		}
		out.newLine();
		
		
		if(enableCommentary) {
			out.write("commentary");
			out.newLine();
		}
		
		
		out.write("endFrames:");
		out.write(Integer.toString(paletteObject.getCutscene().length));
		out.newLine();
		
		for(CustomImageDataII cid : paletteObject.getCutscene()) {
			out.write(cid.getFileName());
//			out.write("*");
//			out.write(CustomAnimationPanel.convertColorToString(cid.getTransparentColor()));
			out.newLine();
		}
		
		out.write("/goal");
		out.newLine();
		
		out.newLine();
		
		
	}
	
	
	@Override
	public int getLayer() {
		
		return 10;
	}
}
